# Quantitative User Study

This folder contains all accompanying documents for the second study (Chapter 5).

## File:   01 - Limesurvey Questionnaire.pdf
An export of the limesurvey questionnaire that was filled out by our study participants.

## Folder: 02 - Content Elements
Contains all 40 content elements used in our trials.
Those are named as follows "\[ID\]-\[NR\].png", where __ID__ is the information density (either _low_ or _medium_) and __NR__ is the number associated to _contentIndex_ value in the _Logging\_TrialStarts-XX.csv_ file of the study data.
You can also use the two training images.

## Folder: 03 - Study Data
Here you can find the recorded and collected study data.
In this folder, there exists 26 folder for the participants __P01__ to __P26__.
In each of those folders, you can find 3 files:
* __Logging\_Input-P-XX.csv__: All inputs on the slider and the "Next" button the participants made.
* __Logging\_TrialStarts-XX.csv__: All times, content ids, and random start values for each trial.
* __trialLog\_1.csv__: All confirmed parameter values for each trial.
Additionally, you can find the folder __\_Other__, which contains aggregated and anonymized data:
* __all numerics.csv__: All numerical answers from the questionnaire.
* __all.xlsx__: The aggregated and numerical study data.

## File: 04 - Questionnaire Answer Overview.xlsx
Overview of the comments given by the participants and used in our study.
Since this study was conducted in 2 languages, parts of the comments were translated by the authors.

## Folder: 05 - Analysis Scripts
All python scripts that we used to pre-process the data, create the statistical analysis, as well as the paper visualizations and more additional visualizations.
We used the following environment and packages to run the scripts:
* python 3.9
* pingouin >= 0.40 (https://pingouin-stats.org/)
* seaborn >= 0.11.1 (https://seaborn.pydata.org/)
* pandas >= 1.3.1
* matplotlib >= 3.4.2
* numpy >= 1.21.1

You can find the following scripts that you can execute in the folder:
* __dataProcessing.py__: This script/class handles the preprocessing of the data. _This should be run first._
* __statisticalCalculations.py__: This script/class will calculate the ANOVAs as well as aggregations over the data.
* __paperVisualizationCreator.py__: This class creates the three result visualizations (Fig. 7-9) used in our paper.
* __otherVisualizationCreator.py__: This class/scripts creates other visualizations that we used to generate first insights of the data.

The results of each script can be found in the created __/out__ folder afterwards.